-----------------------------------------------------------------------------------------------------------------------	
--
--	CUTSCENE: "FOG"
--
-----------------------------------------------------------------------------------------------------------------------	

function Cutscene_FOG_Start()
	Interface_SetCinematicMode(1)
	Display.SetRenderUseGfxSets(0)
	
	Display.SetFogStartAndEnd (1000, 14000)
  	Display.SetRenderFog (1)
	Display.SetFarClipPlaneMinAndMax(0, 40000) 
	
    Display.SetGlobalLightDiffuse(155,154,130)
    Display.SetGlobalLightAmbient(120,110,110)
    

    --Display.SetFogColor (152,172,182)
    Display.SetFogColor (102,102,92)
    
	CreateEntity(1, Entities.XA_Rabbit, GetPosition("CUTSCENE_RABBIT"), "RABBIT" )	
	
	Music.Start( "music\\43_Extra1_DarkMoor_Combat.mp3" , 100, 1 )
	
	
end

function Cutscene_FOG_ChangeFog01()     
	
	TransferDynamicFogAlphaBlending("LeftFog", 1, 1, 7)
	
	
end

function Cutscene_FOG_ChangeFog02()     
	TransferDynamicFogAlphaBlending("LeftFog", 2, 1, 6)
	
end

function Cutscene_FOG_ChangeFog03()     
	TransferDynamicFogAlphaBlending("LeftFog", 3, 1, 4)
	
end

function Cutscene_FOG_ChangeFog04()     
	--TransferDynamicFogAlphaBlending("LEFTFOG", 4, 1, 3)
end


 
function Cutscene_FOG_Move01()     

        SetPosition("RABBIT", GetPosition("CUTSCENE_RABBIT"))
        Move("RABBIT", "CUTSCENE_MOVE_END_RABBIT")
        
 end
 
 
function Cutscene_FOG_Text01()
	 SpokenCinematicText("CM02_03_BigCity/CUTSCENE_FOG_TEXT01")
	
end


function Cutscene_FOG_Text02()
	 SpokenCinematicText("CM02_03_BigCity/CUTSCENE_FOG_TEXT02")
	
end


function Cutscene_FOG_Text03()
	 SpokenCinematicText("CM02_03_BigCity/CUTSCENE_FOG_TEXT03")
	
end


-------------------------------------------------------------------------------------------------------------------------
function Cutscene_FOG_Cancel()
	Cutscene_FOG_Finished()

end

-------------------------------------------------------------------------------------------------------------------------
function Cutscene_FOG_Finished()
	Display.SetRenderUseGfxSets(1)
	Display.SetFarClipPlaneMinAndMax(0, 0) 
	Interface_SetCinematicMode(0)
	CutsceneDone()

end